% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotScot.R
\name{plotScot}
\alias{plotScot}
\title{Plots Counts of Documents or Words over Time (relative to Corpus)}
\usage{
plotScot(
  object,
  id = object$meta$id,
  type = c("docs", "words"),
  rel = FALSE,
  mark = TRUE,
  unit = "month",
  curves = c("exact", "smooth", "both"),
  smooth = 0.05,
  main,
  xlab,
  ylab,
  ylim,
  both.lwd,
  both.col,
  both.lty,
  natozero = TRUE,
  file,
  ...
)
}
\arguments{
\item{object}{\code{\link{textmeta}} object with strictly tokenized
\code{text} component vectors if \code{type = "words"}}

\item{id}{Character: Vector (default: \code{object$meta$id}) which IDs
specify the subcorpus}

\item{type}{Character: Should counts/proportion
of documents \code{"docs"} (default) or words \code{"words"} be plotted?}

\item{rel}{Logical: Should counts
(default: \code{FALSE}) or proportion (\code{TRUE}) be plotted?}

\item{mark}{Logical: Should years be marked by
vertical lines (default: \code{TRUE})?}

\item{unit}{Character: To which unit should
dates be floored (default: \code{"month"}). Other possible units are \code{"bimonth"}, \code{"quarter"}, \code{"season"},
\code{"halfyear"}, \code{"year"}, for more units see \code{\link[lubridate]{round_date}}.}

\item{curves}{Character: Should \code{"exact"},
\code{"smooth"} curve or \code{"both"} be plotted (default: \code{"exact"})?}

\item{smooth}{Numeric: Smoothing parameter
which is handed over to \code{\link{lowess}} as \code{f} (default: \code{0.05}).}

\item{main}{Character: Graphical parameter}

\item{xlab}{Character: Graphical parameter}

\item{ylab}{Character: Graphical parameter}

\item{ylim}{Graphical parameter (default if \code{rel = TRUE}: \code{c(0, 1)})}

\item{both.lwd}{Graphical parameter for smoothed values if \code{curves = "both"}}

\item{both.col}{Graphical parameter for smoothed values if \code{curves = "both"}}

\item{both.lty}{Graphical parameter for smoothed values if \code{curves = "both"}}

\item{natozero}{Logical: Should NAs be coerced
to zeros (default: \code{TRUE})? Only has an effect if \code{rel = TRUE}.}

\item{file}{Character: File path if a pdf should be created.}

\item{...}{additional graphical parameters}
}
\value{
A plot
Invisible: A dataframe with columns \code{date} and \code{counts},
respectively \code{proportion}
}
\description{
Creates a plot of the counts/proportion of documents/words in the subcorpus,
which could be specified by \code{id}.
}
\details{
\code{object} needs a textmeta object with strictly tokenized text component
(character vectors) if you use \code{type = "words"}.
If you use \code{type = "docs"} you can use a tokenized or a non-tokenized text component.
}
\examples{
\donttest{
data(politics)
poliClean <- cleanTexts(politics)

# complete corpus
plotScot(object=poliClean)

# subcorpus
subID <- filterWord(poliClean, search=c("bush", "obama"), out="bin")
plotScot(object=poliClean, id=names(subID)[subID], curves="both", smooth=0.3)
}
}
