% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{nullToNA}
\alias{nullToNA}
\title{Replace NULL values with NA.}
\usage{
nullToNA(x)
}
\arguments{
\item{x}{A list.}
}
\value{
x with all NULL at the top level of the list replaced by NA.
}
\description{
\code{nullToNA} is used to convert any NULL values to NA in a list.
}
\details{
This function is used when reading vectors from mongoDB. If the original
vector had a value of NA, rmongodb converts to NULL before writing to the
database. When rmongodb performs a find, these NULL values are left as NULL,
and when unlisted will shorten the vector. Before unlisting the vector, this
function is run to convert the NULL values to NA so that the vector remains
the correct length and that NAs are in the correct positions.
}
\examples{
\dontrun{nullToNA(list(1,5,'a', NULL, NA, 4))}
}
