% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concentrationProfile.R
\name{plot.conProfile}
\alias{plot.conProfile}
\title{Plot concentration profiles.}
\usage{
\method{plot}{conProfile}(x, session = NULL, what = NULL,
  multiple = FALSE, smooth = FALSE, ...)
}
\arguments{
\item{x}{An object of class \code{conProfile} as returned by
\code{\link{concentration_profile}}.}

\item{session}{A numeric vector of the sessions to be plotted,
defaults to all sessions.}

\item{what}{Which variables should be plotted? Defaults to all
variables in \code{object} (\code{what = NULL}).}

\item{multiple}{Logical. Should all sessions be plotted in one
panel?}

\item{smooth}{Logical. Should unsmoothed profiles be smoothed
before plotting?}

\item{...}{Further arguments to be passed to
\code{\link{smoother_control.distrProfile}}.}
}
\description{
Plot concentration profiles.
}
\examples{
data('runs', package = 'trackeR')
dProfile <- distributionProfile(runs, session = 1:3, what = 'speed',
                                grid = seq(0, 12.5, by = 0.05))
cProfile <- concentrationProfile(dProfile)
\dontrun{
plot(cProfile, smooth = FALSE)
plot(cProfile)
}
}
