% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Generics.R, R/PlotWrapper.R,
%   R/accessor-methods.R
\docType{methods}
\name{fullData}
\alias{fullData}
\alias{fullData,PlotFeatureSet-method}
\alias{fullData,ggplot-method}
\alias{fullData,trellis-method}
\alias{fullData,gTree-method}
\alias{fullData,PlotFeatureSet-method}
\title{Accessor method for the data (slot "data") that is used in plotting.}
\usage{
fullData(object, quiet = FALSE)

\S4method{fullData}{PlotFeatureSet}(object)

\S4method{fullData}{ggplot}(object, quiet = FALSE)

\S4method{fullData}{trellis}(object, quiet = FALSE)

\S4method{fullData}{gTree}(object)

\S4method{fullData}{PlotFeatureSet}(object)
}
\arguments{
\item{object}{An object of (super)class PlotFeatureSet. For accession, also plot objects of class ggplot or trellis.}

\item{quiet}{Should warnings about plotted data be supressed?}
}
\value{
A list of data.frame containing the variables used in plotting.
}
\description{
Get full data associated with a plot or model fit, if possible.
}
\examples{
library(ggplot2)
plt = qplot(mtcars$mpg, mtcars$cyl)
fs = makeFeatureSet(plt)
fullData(fs)
}
