% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HypoMonMethods.R
\docType{methods}
\name{defineMarketTools-methods}
\alias{defineMarketTools-methods}
\alias{HypoMonTest}
\alias{HypoMonTest,TariffBertrand-method}
\alias{HypoMonTest,TariffCournot-method}
\title{Methods For Implementing The Hypothetical Monopolist Test}
\usage{
\S4method{HypoMonTest}{TariffBertrand}(object, prodIndex, ssnip = 0.05, ...)

\S4method{HypoMonTest}{TariffCournot}(object, plantIndex, prodIndex, ssnip = 0.05, ...)
}
\arguments{
\item{object}{An instance of one of the classes listed above.}

\item{prodIndex}{A vector of product indices that are to be placed under the control of the Hypothetical Monopolist.}

\item{ssnip}{A number between 0 and 1 that equals the threshold for a \dQuote{Small but Significant and
Non-transitory Increase in Price} (SSNIP). Default is .05, or 5\%.}

\item{...}{Pass options to the optimizer used to solve for equilibrium prices.}

\item{plantIndex}{A vector of plant indices that are to be placed under the control of the Hypothetical Monopolist (Cournot).}
}
\value{
\code{HypoMonTest} returns TRUE if a profit-maximizing Hypothetical Monopolist who controls the products indexed by
\sQuote{prodIndex} would increase the price of at least one of the products in \sQuote{prodIndex} by a \sQuote{ssnip}, and
FALSE otherwise.
}
\description{
An adaptation of the Hypothetical Monopolist Test described in the 2010 Horizontal Merger Guidelines for use in non-merger settings.

\code{\link{HypoMonTest}} implements the Hypothetical Monopolist Test for a given \sQuote{ssnip}.
\sQuote{...} may be used to pass arguments to the optimizer.
}
\details{
\code{HypoMonTest} is an implementation of the Hypothetical Monopolist Test
on the products indexed by \sQuote{prodIndex} for a \sQuote{ssnip}. The
Hypothetical Monopolist Test determines whether a profit-maximizing
Hypothetical Monopolist who controls the products indexed by
\sQuote{prodIndex} would increase the price of at least one of the products in \sQuote{prodIndex} by a
small, significant, and non-transitory amount (i.e. impose a SSNIP). The  main difference between this implementation and
\code{\link[antitrust:HypoMonTest]{antitrust::HypoMonTest()}} is this implementation does not check to see if \sQuote{prodIndex} contains a merging party's product.
}
\references{
U.S. Department of Justice and Federal Trade Commission,
\emph{Horizontal Merger Guidelines}. Washington DC: U.S. Department of Justice, 2010.
\url{https://www.justice.gov/atr/horizontal-merger-guidelines-08192010} (accessed July 29, 2011).
}
\keyword{methods}
