% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ots_product_code.R
\name{ots_product_code}
\alias{ots_product_code}
\title{String matching of official product names and Harmonized System (HS) codes
according to the United Nations nomenclature}
\usage{
ots_product_code(productname = NULL, productgroup = NULL)
}
\arguments{
\item{productname}{A text string such as "Animals", "COPPER" or "fruits".}

\item{productgroup}{A text string such as "meat", "FISH" or "Dairy".}
}
\value{
A tibble with all possible matches (no uppercase distinction)
showing the product name, product code and corresponding trade
classification (e.g. HS92 or SITC)
}
\description{
This function takes a text string and searches within the
package data for all matching product codes in the context of valid API
product codes.
}
\examples{
ots_product_code(productname = "ANIMALS ")
ots_product_code(productgroup = "  fish")
ots_product_code(productname = "Milk", productgroup = "Dairy")
ots_product_code()
}
\keyword{functions}
