% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment.R
\name{augment_roads}
\alias{augment_roads}
\title{Augment roads with predicted traffic quantities}
\usage{
augment_roads(fit, roads, probs = c(0.025, 0.975), keep_geometry = TRUE)
}
\arguments{
\item{fit}{a `traffic_fit` object from `fit_traffic()`.}

\item{roads}{an sf object or data.frame with a segment id column.}

\item{probs}{length-2 numeric for equal-tail intervals.}

\item{keep_geometry}{logical; if FALSE drops sf geometry.}
}
\value{
roads with added columns:
  predicted_mean, predicted_lo, predicted_hi,
  relative_congestion
}
\description{
Adds predicted traffic outcomes (e.g. speed or volume) and
relative congestion measures to a road network.
}
