% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.traitdata.R
\name{as.traitdata}
\alias{as.traitdata}
\title{Standardize format of traitdata}
\usage{
as.traitdata(x, traits = attributes(x)$traits,
  taxa = attributes(x)$taxa, occurrences = attributes(x)$occurrences,
  datasetID = attributes(x)$datasetID,
  measurements = attributes(x)$measurements,
  units = attributes(x)$units, keep = attributes(x)$keep,
  drop = attributes(x)$drop, na.rm = TRUE,
  id.vars = names(x)[names(x) \%in\% keep & !names(x) \%in\% drop],
  thesaurus = attributes(x)$thesaurus,
  metadata = attributes(x)$metadata, longtable = TRUE, ...)
}
\arguments{
\item{x}{data.frame object, containing at least a column of taxa, and one or
more columns of trait measurements.}

\item{traits}{a vector of column names containing traits.}

\item{taxa}{the name of the column containing taxon names.}

\item{occurrences}{either a column name containing identifiers for each
individual specimen on which several traits were measured, i.e. an
occurrence of this taxon, or a vector of occurrence identifiers which must
be of the same length as the number of rows of the table. See 'Details'.}

\item{datasetID}{a unique name for this dataset (optional). Will be prepended
to the occurrence ID and measurement ID.}

\item{measurements}{either a column name containing identifiers for each
individual measurement, or a vector of measurement identifiers. This
applies, if single trait measurements span across multiple columns of data,
e.g. multivariate traits like quantitative measures of chemical compounds,
wavelengths or x-y-z coordinates. In most cases, a measurementID will link
the data across rows in the longtable format. Make sure that the traitnames
given reflect the different dimensions of the trait measurement. If
\code{measurement} remains blank, sequential identifiers will be auto-generated
for each measured value.}

\item{units}{a single character string or named vector giving the units that
apply to the traits. If only one unit type is given, it will be applied to
all traits.}

\item{keep}{a vector or named vector containing the names of the input
columns to be kept in the output. Vector names will be used to rename the
columns. It is recommended to use accepted column names of the traitdata
standard for renaming!}

\item{drop}{a vector acting as the inverse of \code{keep}. All columns listed will
be removed from the output dataset.}

\item{na.rm}{logical defaults to \code{TRUE}. If \code{FALSE}, all measured Values
containing NA will be kept in the output table. This is not reccomended for
most data.}

\item{id.vars}{a vector of column names to return. Autogenerated from input
column names and 'keep' and 'drop'.}

\item{thesaurus}{an object of class 'thesaurus' as created by function
\code{as.thesaurus()}. If provided, this will superimpose trait names provided
in argument \code{traits}. The thesaurus will be appended as an attribute and
can be revisited by calling \code{attributes(x)$thesaurus}.}

\item{metadata}{a list of class metadata, as created by function
\code{as.metadata()}. Metadata will be added as attributes to the data table.
Possible parameters to the function call are: \code{rightsHolder},
\code{bibliographicCitation}, \code{license}, \code{author}, \code{datasetID}, \code{datasetName},
\code{version}. (see 'Details')}

\item{longtable}{logical, defaults to \code{TRUE}. If \code{FALSE}, data will not be
converted into lontable format, but remain in widetable format as provided.
Note that any columns not indicated in arguments \code{traits}, \code{keep}, \code{units},
\code{taxa}, \code{occurrences} will be dropped from the output.}

\item{...}{other arguments, passed on to print function.}
}
\description{
Turns wide-table formats (species-traits matrix and occurrence table) into
long-table format. As input, the function requires information about which
columns contain traits, given as a list of trait-names, and which column
contains the taxon name. For tables containing repeated measurements of
traits within the same taxon, an occurrenceID should be given or will be
created.
}
\details{
If \code{occurrences} is left blank, the script will check for the
structure of the input table. If several entries are given for the same
taxon, it assumes that input is an occurrence table, i.e. with multiple
observations of a single taxon,  and assigns identifiers.

Metadata will be stored as attributes to the data frame and can be accessed
via \code{attributes()}. It is not necessary but highly recommended to provide
metadata when working with multiple trait data files. When appending
datasets using \code{rbind()}, the metadata information will be added as
additional columns and dataset attribution will be listed in attributes.
}
\examples{

\dontrun{
# species-trait matrix:

pulldata("carabids")

dataset1 <- as.traitdata(carabids,
  taxa = "name_correct",
  traits = c("body_length", "antenna_length", "metafemur_length"),
  units = "mm",
  keep = c(basisOfRecordDecription = "source_measurement", measurementRemark = "note")
  )

# occurrence table:

pulldata("heteroptera_raw")

dataset2 <- as.traitdata(heteroptera_raw,
  taxa = "SpeciesID",
  traits = c("Body_length", "Body_width", "Body_height", "Thorax_length",
    "Thorax_width", "Head_width", "Eye_width", "Antenna_Seg1", "Antenna_Seg2",
    "Antenna_Seg3", "Antenna_Seg4", "Antenna_Seg5", "Front.Tibia_length",
    "Mid.Tibia_length", "Hind.Tibia_length", "Front.Femur_length",
    "Hind.Femur_length", "Front.Femur_width", "Hind.Femur_width",
    "Rostrum_length", "Rostrum_width", "Wing_length", "Wing_widt"),
  units = "mm",
  keep = c(sex = "Sex", references = "Source", lifestage = "Wing_development"),
  metadata = as.metadata(
    author = "Gossner MM, Simons NK, HC6ck L and Weisser WW",
    datasetName = "Morphometric traits Heteroptera",
    bibliographicCitation = attributes(heteroptera_raw)$citeAs,
    license = "http://creativecommons.org/publicdomain/zero/1.0/"
    )
)
}

}
