% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Step2Selection.R
\name{Step2Selection}
\alias{Step2Selection}
\alias{print.trajSelection}
\alias{summary.trajSelection}
\title{Select a Subset of the Measures Using Factor Analysis}
\usage{
Step2Selection(trajMeasures, num.select = NULL, discard = NULL, select = NULL)

\method{print}{trajSelection}(x, ...)

\method{summary}{trajSelection}(object, ...)
}
\arguments{
\item{trajMeasures}{object of class \code{trajMeasures} as returned by
\code{\link[traj]{Step1Measures}}.}

\item{num.select}{an optional positive integer indicating the number of
factors to keep in the second stage of the algorithm. Defaults to NULL so
that all factors with variance greater than any one of the normalized
measures are selected.}

\item{discard}{an optional vector of positive integers corresponding to the
measures to be dropped from the analysis. See
\code{\link[traj]{Step1Measures}} for the list of measures. Defaults to
NULL.}

\item{select}{an optional vector of positive integers corresponding to the
measures to forcefully select. Defaults to NULL. If a vector is supplied,
the five-steps selection algorithm described above is bypassed and the
corresponding measures are selected instead.

Can be NULL or a numeric vector corresponding to the numerical identifier of
measures present in \code{trajMeasures}. If a numeric vector is supplied,
then four-steps selection algorithm described above is bypassed and the
corresponding measures are selected instead.}

\item{x}{object of class trajSelection.}

\item{...}{further arguments passed to or from other methods.}

\item{object}{object of class trajSelection.}
}
\value{
An object of class \code{trajSelection}; a list containing the values
of the selected measures, the output of the principal component analysis as
well as a curated form of the arguments.
}
\description{
This function applies the following dimension reduction algorithm
to the measures computed by \code{\link[traj]{Step1Measures}}:
\enumerate{
\item Use principal component analysis (PCA) on the measure to form factors summarizing the variability in the measures;
\item Drop the factors whose variance is smaller than any one of the normalized measures;
\item Performs a varimax rotation on the remaining factors;
\item For each rotated factor, select the measure that has the highest correlation (aka factor loading) with it and that hasn't yet been selected;
\item Drop the remaining measures.
}
}
\details{
In the presence of highly correlated measures (Pearson correlation >
0.98), the function selects the highest-ranking measure on the list (see
\code{\link[traj]{Step1Measures}}) and discards the others. Because the
K-means algorithm is sensitive to outliers, measures which are quotients
(i.e. 4, 7, 8, 15-17, 21-26) are prevented from taking extremely large or
infinite values (caused by division by 0). Nishiyama's improved Chebychev
bound is used to determine extreme values for each measure, corresponding to
a 0.3\% probability threshold. Extreme values beyond the threshold are capped
to the 0.3\% probability threshold. Measures corresponding to quotients which
would be of the form 0/0 are set to 1. PCA is applied on the remaining
measures using the \code{\link[psych]{principal}} function from the
\code{psych} package.
}
\examples{
\dontrun{
m = Step1Measures(trajdata, ID = TRUE)
s = Step2Selection(m)

s$RC$loadings

s2 = Step2Selection(m, select = c(10, 12, 8, 4))
}


}
\references{
Leffondre K, Abrahamowicz M, Regeasse A, Hawker GA, Badley EM,
McCusker J, Belzile E. Statistical measures were proposed for identifying
longitudinal patterns of change in quantitative health indicators. J Clin
Epidemiol. 2004 Oct;57(10):1049-62. doi: 10.1016/j.jclinepi.2004.02.012.
PMID: 15528056.
}
\seealso{
\code{\link[psych]{principal}} \code{\link[traj]{Step1Measures}}
}
