% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rediscretize.R
\name{TrajRediscretize}
\alias{TrajRediscretize}
\title{Resample a trajectory to a constant step length}
\usage{
TrajRediscretize(trj, R)
}
\arguments{
\item{trj}{The trajectory to be resampled.}

\item{R}{rediscretization step length.}
}
\value{
A new trajectory with a constant segment length which follows
  \code{trj}.
}
\description{
Constructs a new trajectory by resampling the input trajectory to a fixed
step (or segment) length. Timing of frames is lost, so speed and acceleration
cannot be calculated on a rediscretized trajectory.
}
\details{
Based on the appendix in Bovet and Benhamou, (1988).
}
\references{
Bovet, P., & Benhamou, S. (1988). Spatial analysis of animals' movements using a correlated random walk model. Journal of Theoretical Biology, 131(4), 419-433. doi:10.1016/S0022-5193(88)80038-9
}
