% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{TrajAngles}
\alias{TrajAngles}
\title{Turning angles of a Trajectory}
\usage{
TrajAngles(trj, lag = 1, compass.direction = NULL)
}
\arguments{
\item{trj}{the trajectory whose whose angles are to be calculated.}

\item{lag}{Angles between every lag'th segment are calculated. Only applies
to non-directed walks, i.e. \code{compass.direction} is \code{NULL}.}

\item{compass.direction}{If not \code{NULL}, step angles are calculated
relative to this angle (in radians), otherwise they are calculated relative
to the previous step angle.}
}
\value{
Step angles in radians, normalised so that \code{-pi < angle <= pi}.
}
\description{
Calculates the step angles (in radians) of each segment, either relative to
the previous segment or relative to the specified compass direction.
}
\details{
Note that since turning angles are circular quantities, i.e. 360° == 0°, it
is incorrect to treat them as linear quantities. In particular, do not
calculate arithmetic means or standard deviations of turning angles. See
Batschelet, (1981) for a detailed explanation and techniques for dealing with
circular quantities.
}
\references{
Batschelet, E. (1981). Circular statistics in biology. ACADEMIC PRESS, 111
FIFTH AVE., NEW YORK, NY 10003, 1981, 388.
}
\seealso{
\code{\link{TrajStepLengths}},
  \code{\link{TrajMeanVectorOfTurningAngles}}
}
