% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/speed.R
\name{TrajDerivatives}
\alias{TrajDerivatives}
\title{Calculates trajectory speed and change of speed}
\usage{
TrajDerivatives(trj)
}
\arguments{
\item{trj}{Trajectory whose speed and change in speed is to be calculated.}
}
\value{
A list with components: \item{speed}{numeric vector, speed between
  each pair of trajectory points, i.e. the speed of each step.}
  \item{speedTimes}{numeric vector, times corresponding to values in
  \code{speed}, i.e. the time from the start of the trajectory to the end of
  each step.} \item{acceleration}{numeric vector, change in speed between
  steps. Despite the name, this is not acceleration as defined by mechanics.}
  \item{accelerationTimes}{numeric vector, time from the start of the
  trajectory to the end of the second step in each pair.}
}
\description{
Calculates speed and change of speed along a trajectory over time. These are
the first and second order derivatives of distance travelled over time. Noisy
trajectories should be smoothed before being passed to this function, as
noise is effectively amplified when taking derivatives.
}
\details{
The value returned as \code{acceleration} is \emph{not} technically
acceleration. In mechanics, acceleration is a vector. The returned value is a
scalar quantity: change of speed, which is sometimes known informally as
acceleration. This value corresponds to the acceleration in a 1-dimensional
trajectory, with the sign indicating the direction of acceleration relative
to the current direction of velocity. See \code{\link{TrajAcceleration}} for
an approximation of (vector) acceleration, and \code{\link{TrajVelocity}} for
an approximation of velocity.
}
\seealso{
\code{\link{TrajSpeedIntervals}} for analysing intervals of low or
  high speed within the trajectory. \code{\link{TrajSmoothSG}} for smoothing
  a trajectory. \code{\link{TrajAcceleration}} for calculating acceleration,
  and \code{\link{TrajVelocity}} for calculating velocity.
}
