% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xpssAddValueLabels.R
\name{xpssAddValueLabels}
\alias{xpssAddValueLabels}
\title{Modifies value labels}
\usage{
xpssAddValueLabels(x, variables = NULL, values = NULL, labels = NULL,
  datevariables = NULL, datevalues = NULL, datelabels = NULL)
}
\arguments{
\item{x}{a (non-empty) data.frame or input data of class \code{"xpssFrame"}.}

\item{variables}{atomic character or character vector with the name of the variables.}

\item{values}{atomic numeric or numeric vector, respectively as an atomic character or character vector containing the value of the variable.}

\item{labels}{atomic numeric or numeric vector, respectively as an atomic character or character vector containing the label of the variable.}

\item{datevariables}{atomic date or date vector with the name of the date variables.}

\item{datevalues}{atomic date or date vector containing the value of the date, the value has to be like the old date format.}

\item{datelabels}{atomic numeric or numeric vector, respectively as an atomic character or character vector containing a variable label.}
}
\value{
An xpssFrame object with modified value labels.
}
\description{
R implementation of the SPSS \code{ADD VALUE LABELS} function. \code{xpssAddValueLabels} appends value labels for specific variables. Those values labels get stored in the attributes of the selected variable.
}
\details{
The values labels are stored in the variable itself.
\cr In contrast to \code{\link{xpssValueLabels}} , \code{xpssAddValueLabels} do not erase existing value labels. \cr If the value label for a specific variable already exists, this value label get overwritten. \cr If the value label for a specific variable does not exist, the value label get created without deleting the existing value label of that variable.
\cr\cr Supported attributes are:
\code{value.labels}, \code{defined.MIS}, \code{MIS}, \code{varname}, \code{variable.label}
}
\examples{
data(fromXPSS)

fromXPSS <- xpssValueLabels(fromXPSS,
                           variables = "V1",
                           values = 1 ,
                           labels = "Label1")

fromXPSS <- xpssAddValueLabels(fromXPSS,
                           variables = "V1",
                           values = 2 ,
                           labels = "Label2")

fromXPSS <- xpssAddValueLabels(fromXPSS,
                           variables = "V1",
                           values = "B" ,
                           labels = "CharLabel")



attributes(fromXPSS$V1)$value.labels
}
\author{
Bastian Wiessner
}
\seealso{
\code{\link{read.spss}} \code{\link{xpssValueLabels}} \code{\link{xpssVariableLabels}}
}

