% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chi2dob.R
\name{chi2dob}
\alias{chi2dob}
\title{Convert CHI number to date of birth}
\usage{
chi2dob(chi, paed = FALSE, cent = FALSE)
}
\arguments{
\item{chi}{vector of CHI numbers (as numeric or string)}

\item{paed}{Whether paediatric patient (TRUE/FALSE), either a vector or a
single TRUE/FALSE for whole series}

\item{cent}{Whether born before 1920 (TRUE/FALSE), either a vector or a
single TRUE/FALSE for whole series}
}
\value{
a vector of POSIXct dates
}
\description{
A vectorised function to convert a Scottish CHI number to date of birth in
POSIXct date format. Note that this function does not always work as not all
CHI numbers correspond accurately to date of birth, and any person born
before 1920 will appear to be 100 years younger unless the optional cent
parameter set to TRUE. Childen born in or after 2020 will appear 100 years
older unless the optional paed parameter is set to TRUE. This function requires the
stringr package.
}
\details{
The paed and cent parameters can either be provided as vectors for each case,
for example in a series where there are patients with dates of birth in both
the 1910s and 2010s, or alternatively can be set as a single TRUE or FALSE for
the whole series.
}
\examples{
# as a single numeric
chi2dob(1503541234)

# as a single character string, for a patient born in 1919
chi2dob("1108191234", cent = TRUE)

# as a mixed vector of adults and children, including one born in 1919
chi2dob(chi = c("1503541234", "1108191234", "0510141234"),
        cent = c(FALSE, TRUE, FALSE))
}
