% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ukkri.R
\name{ukkrri_q}
\alias{ukkrri_q}
\title{UK Kidney Recipient Risk Index Quartile (2019)}
\usage{
ukkrri_q(rri, prefix = FALSE, fct = FALSE)
}
\arguments{
\item{rri}{numeric vector of UKKRRI values}

\item{prefix}{whether to prefix results with "R" (default FALSE)}

\item{fct}{whether to return results as a factor (default FALSE)}
}
\value{
vector of UKKRRI quartiles
}
\description{
Vectorised function to convert UKKRRI values to quartiles of risk. The function takes a numeric
vector of UKKRRI values as input, and returns a vector of quartiles. By default this is also a
numeric vector with values 1-4, but this can be changed to a character string vector of R1-R4 to
match the nomenclature in the NHSBT ODT documentation by setting the prefix parameter to TRUE. The
output can also be as a vector of factors by setting fct to TRUE (this can be combined with the
prefix parameter).
}
\details{
The UK KRRI quartile ranges are documented in the UK kidney matching policy which can be found
on the NHS Blood & Transplant ODT website at www.odt.nhs.uk
}
\examples{
# obtain quartile of a single value
ukkrri_q(1.01)

# factor vector of results with prefix
rri = c(0.69, 0.75, 0.96, 1.36)
ukkrri_q(rri, prefix = TRUE, fct = TRUE)
}
