% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unbalanced_wpp.R
\name{plot.ut_wpp}
\alias{plot.ut_wpp}
\title{Plot Unbalanced Transport Information}
\usage{
\method{plot}{ut_wpp}(
  x,
  what = c("plan", "extra", "trans"),
  axes = FALSE,
  xlim = c(0, 1),
  ylim = c(0, 1),
  ...
)
}
\arguments{
\item{x}{the list returned by \code{\link{unbalanced}} with option \code{output="all"}.}

\item{what}{character. The aspect of the unbalanced transport information to display.}

\item{axes}{logical. Whether to plot axes (ignored for \code{what="plan"}).}

\item{xlim, ylim}{numeric vectors of length 2. The x- and y-limits of the plot.}

\item{...}{further graphics parameters passed to \code{\link{plot.pgrid}} for 
\code{what="plan"} and passed to \code{\link{matimage}} in all other cases.}
}
\value{
Nothing. Used for the side effect.
}
\description{
Graphic representation of components of the list returned by \code{\link{unbalanced}}.
}
\examples{
\dontrun{
set.seed(33)
m <- 50
n <- 20
massa <- rexp(m)
massb <- rexp(n)
a <- wpp( matrix(runif(2*m), m, 2), massa)
b <- wpp( matrix(runif(2*n), n, 2), massb)
res <- unbalanced(a,b,1,0.3,output="all")
plot(res, what="plan")
plot(res, what="trans")
plot(res, what="extra")}
}
