% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_filter_postcode_districts.R
\name{time_filter_postcode_districts}
\alias{time_filter_postcode_districts}
\title{Time Filter (Postcode Districts)}
\usage{
time_filter_postcode_districts(
  departure_searches = NULL,
  arrival_searches = NULL
)
}
\arguments{
\item{departure_searches}{One or more objects created by \code{\link{make_search}}}

\item{arrival_searches}{One or more objects created by \code{\link{make_search}}}
}
\value{
API response parsed as a list and as a raw json
}
\description{
Find districts that have a certain coverage from origin (or to destination) and get statistics about postcodes within such districts.
Currently only supports United Kingdom.
}
\details{
See \url{https://docs.traveltime.com/api/reference/postcode-district-filter/} for details
}
\examples{
\dontrun{
departure_search <-
  make_search(id = "public transport from Trafalgar Square",
              departure_time = strftime(as.POSIXlt(Sys.time(), "UTC"), "\%Y-\%m-\%dT\%H:\%M:\%SZ"),
              travel_time = 1800,
              coords = list(lat = 51.507609, lng = -0.128315),
              transportation = list(type = "public_transport"),
              reachable_postcodes_threshold = 0.1,
              properties = list("coverage", "travel_time_reachable", "travel_time_all"))

arrival_search <-
  make_search(id = "public transport to Trafalgar Square",
              arrival_time = strftime(as.POSIXlt(Sys.time(), "UTC"), "\%Y-\%m-\%dT\%H:\%M:\%SZ"),
              travel_time = 1800,
              coords = list(lat = 51.507609, lng = -0.128315),
              transportation = list(type = "public_transport"),
              reachable_postcodes_threshold = 0.1,
              properties = list("coverage", "travel_time_reachable", "travel_time_all"))

result <-
  time_filter_postcode_districts(
    departure_searches = departure_search,
    arrival_searches = arrival_search
  )
}
}
