% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.modifiers.R
\name{make.modifiers}
\alias{make.modifiers}
\title{make.modifiers}
\usage{
make.modifiers(
  branch.length = NULL,
  selection = NULL,
  speciation = NULL,
  condition = NULL,
  modify = NULL,
  add = NULL,
  update = NULL,
  test = TRUE
)
}
\arguments{
\item{branch.length}{A function for the waiting time generating branch length (can be left empty for the defeault branch length function; see details).}

\item{selection}{A function for selecting the lineage(s) affected by speciation (can be left empty for the default selection function; see details).}

\item{speciation}{A function for triggering the speciation events (can be left empty for the default speciation function; see details).}

\item{condition}{A function giving the condition on which to modify the output of \code{branch.length} or \code{speciation} (see details). If \code{NULL} the condition is always met.}

\item{modify}{A function giving the rule of how to modify the output of \code{branch.length} or \code{speciation} (see details). If \code{NULL} no modification is used.}

\item{add}{Whether to add this modifier to a \code{"treats"} \code{"modifier"} object.}

\item{update}{Optional, another previous \code{"treats"} modifiers object to update (see details).}

\item{test}{Logical whether to test if the modifiers object will work (default is TRUE).}
}
\value{
This function outputs a \code{treats} object that is a named list of elements handled internally by the \code{\link{treats}} function.
}
\description{
Making modifiers objects for treats based on an ancestor's (parent) trait.
}
\details{
\code{branch.length}, \code{selection} and \code{speciation} must be a functions that intakes the following arguments: \code{bd.params, lineage, trait.values, modify.fun}. If left empty, any of these arguments is considered as NULL.

The default \code{branch.length} function is drawing a random number from the exponantial distribution with a rate equal to the current number of taxa multiplied by the speciation and extinction (\code{rexp(1, n_taxa * (speciation + extinction))}).

The default \code{selection} function is randomly drawing a single lineage among the ones present at the time of the speciation (\code{sample(n_taxa, 1)}).

The default \code{speciation} function is drawing a random number from a uniform distribution (0,1) and starts a speciation event if this random number is lower than the ration of speciation on speciation and extinction (\code{runif(1) < (speciation/(speciation + extinction))}). If the random number is greater, the lineage goes extinct.

\code{condition} must be a function with unambiguous input (the inputs listed about for \code{branch.length} and \code{speciation}) and must output a single \code{logical} value. 

For example a conditional on the number of taxa:

    \code{condition = function(lineage) return(lineage$n < 1)}

or a conditional on the trait values:

    \code{condition = function(trait.values, lineage)}
    \code{    \{}
    \code{    parent.traits(trait.values, lineage) < mean(trait.values)}
    \code{    \}}

\code{modify} must be a function with at least one input named \code{x} (which will be the branch length or the speciation trigger to value depending on the modifier) and must return a \code{numeric} value.
For example a constant modification of the input:

    \code{modify = function(x) return(x * 2)}

or a modifier depending on the number of taxa:

    \code{modify = function(x, lineage) return(x/lineage$n)}


When using \code{update}, the provided arguments (to \code{make.modifiers}) will be the ones updated in the \code{"modifiers"} object.
If the \code{"modifiers"} object contains multiple modifiers (\code{branch.length}, \code{selection} or \code{speciation}), only the called arguments will be updated (e.g. \code{make.modifiers(update = previous_modifiers, speciation = new_speciation)} will only update the speciation process).

More details about the \code{modifiers} functions is explained in the \code{treats} manual: \url{http://tguillerme.github.io/treats}.
}
\examples{
## These functions should be fed to the make.modifiers function to create
## modifiers for treats objects. For example, the following sets specifies that
## the branch length should be generated using the branch.length.trait function
## the selection using the selection function and the speciation using the
## speciation.trait function:
my_modifiers <- make.modifiers(branch.length = branch.length.trait,
                               selection     = selection,
                               speciation    = speciation.trait)

## Creating a treats simulation using these modifiers
treats(stop.rule = list(max.taxa = 20),
     traits = make.traits(),
     modifiers = my_modifiers)

}
\seealso{
\code{\link{treats}} \code{\link{modifiers}}
}
\author{
Thomas Guillerme
}
