% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{get_defaults}
\alias{get_defaults}
\title{Get Default Options for \pkg{treePlotArea}}
\usage{
get_defaults()
}
\value{
A named list.
It has the following entries giving the column names of the
angle count or boundary data that hold information on:
\describe{
    \item{angle_counts}{ \describe{
        \item{tract_id}{The tract id.}
        \item{corner_id}{The corner id.}
        \item{tree_id}{The tree id.}
        \item{distance}{The distance from the center of the tract's corner.}
        \item{azimuth}{The azimuth from North.}
        \item{dbh}{The diameter at breast height.}
    }}
    \item{boundaries}{ \describe{
        \item{tract_id}{The tract id.}
        \item{corner_id}{The corner id.}
        \item{boundary_type}{Type of boundary.}
        \item{boundary_status}{Validity of the boundary.}
        \item{distance_start}{The starting point's distance.}
        \item{distance_flexing}{The flexing point's distance.}
        \item{distance_end}{The ending point's distance.}
        \item{azimuth_start}{The starting point's azimuth.}
        \item{azimuth_flexing}{The flexing point's azimuth.}
        \item{azimuth_end}{The ending point's azimuth.}
        }}
}
}
\description{
Used to see (not \emph{set}) the default options set by \pkg{treePlotArea}.
Use \code{\link{set_options}} to change these default values.
}
\examples{
get_defaults()
}
\seealso{
Other option functions: 
\code{\link{set_options}()}
}
\concept{option functions}
