% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/B1I.R
\name{B1I}
\alias{B1I}
\title{Calculation of the B1 index for rooted trees}
\usage{
B1I(tree)
}
\arguments{
\item{tree}{A rooted tree in phylo format.}
}
\value{
\code{B1I} returns the B1 index of the given tree.
}
\description{
This function calculates the \eqn{B1} index \eqn{B1(T)} for a given rooted
tree \eqn{T}. The tree must not necessarily be binary. \eqn{B1(T)} is defined as
\deqn{B1(T)=\sum_{u\in V_{in}(T)\setminus\{\rho\}} h(T_u)^{-1}}{
B1(T)=\sum_{u in V'_in(T)} h(T_u)^(-1)} in which
\eqn{V_{in}(T)\setminus\{\rho\}}{V'_in(T)} denotes the set of inner vertices of \eqn{T} without the root, and
\eqn{h(T_u)} denotes the height of the pending subtree rooted at \eqn{u}.
When restricted to binary trees, the \eqn{B1} index is a balance index. For
arbitrary trees it does not fulfill the definition of an (im)balance index.\cr\cr
For \eqn{n=1} the function returns \eqn{B1(T)=0} and a warning.
}
\examples{
tree <- ape::read.tree(text="((((,),),(,)),(((,),),(,)));")
B1I(tree)

}
\references{
K.-T. Shao and R. R. Sokal. Tree Balance. Systematic Zoology, 39(3):266, 1990. \cr doi: 10.2307/2992186.
}
\author{
Sophie Kersting
}
