% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_cophy.R
\name{add_events}
\alias{add_events}
\title{Add events from sim_cophyBD to plot.cophy}
\usage{
add_events(
  cophy_obj,
  legend = TRUE,
  pch = NULL,
  col = NULL,
  gap = 1,
  fsize = 1,
  type = "phylogram",
  show_tip_label = TRUE
)
}
\arguments{
\item{cophy_obj}{Cophylogenetic object}

\item{legend}{Boolean to turn on or off the legend}

\item{pch}{Length 8 vector of plotting symbols to be used}

\item{col}{Length 8 vector of colors to be used in plot}

\item{gap}{the gap between the two trees}

\item{fsize}{the font size of tips (this must be set the same as used in plot.cophy)}

\item{type}{the type of graph ("phylogram" or "cladogram")}

\item{show_tip_label}{Boolean indicating whether the plot has tip labels or not}
}
\description{
This will plot the classical cophylogenetic events onto
the plot from plot.cophy if event_history is non-empty. At present this
only works with phylograms.
}
\details{
The pch and color vectors place symbols or colors for the different events.
The order this vector is input determines which symbol corresponds to which
event.
  * Position 1 = cospeciation
  * Position 2 = host speciation
  * Position 3 = host extinction
  * Position 4 = symbiont speciation
  * Position 5 = symbiont extinction
  * Position 6 = host spread or host-switch symbiont speciation
  * Position 7 = anagenetic symbiont dispersal
  * Position 8 = anadenetic symbiont extirpation

 By default a color vector is used in this order: purple, red, blue,
 darkorange, cyan, yellow, brown, seagreen
}
\examples{
host_mu <- 1.0 # death rate
host_lambda <- 2.0 # birth rate
numb_replicates <- 10
time <- 1.0
symb_mu <- 0.2
symb_lambda <- 0.4
host_shift_rate <- 0.0
cosp_rate <- 2.0

cophylo_pair <- sim_cophyBD(hbr = host_lambda,
                           hdr = host_mu,
                           cosp_rate = cosp_rate,
                           host_exp_rate = host_shift_rate,
                           sdr = symb_mu,
                           sbr = symb_lambda,
                           numbsim = numb_replicates,

                           time_to_sim = time)
plot.cophy(cophylo_pair[[1]])
add_events(cophylo_pair[[1]], legend = FALSE)
}
