% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_cophylo.R
\name{c.cophy}
\alias{c.cophy}
\alias{c.multiCophy}
\title{Combine cophylogenetic sets into a multiCophy object}
\usage{
\method{c}{cophy}(...)

\method{c}{multiCophy}(...)
}
\arguments{
\item{...}{Values of class `cophy`}
}
\value{
An object of class `multiCophy`
}
\description{
Combines cophylogenetic sets into a multiCophy object.
}
\section{Functions}{
\itemize{
\item \code{c.multiCophy}: Combines two multiCophy objects into one multiCophy object
}}

\examples{
h_lambda <- 1.0
h_mu <- 0.3
c_lambda <- 0.0
s_lambda <- 1.0
s_mu <- 0.3
s_her <- 0.0
host_symb_sets <-  sim_cophylo_bdp(hbr = h_lambda,
                                  hdr = h_mu,
                                  sbr = s_lambda,
                                  cosp_rate = c_lambda,
                                  sdr = s_mu,
                                  host_exp_rate = s_her,
                                  time_to_sim = 1.0,
                                  numbsim = 2)
host_symb_sets2 <- sim_cophylo_bdp(hbr = h_lambda,
                                  hdr = h_mu,
                                  sbr = s_lambda,
                                  cosp_rate = c_lambda,
                                  sdr = s_mu,
                                  host_exp_rate = s_her,
                                  time_to_sim = 1.0,
                                  numbsim = 2)
multi_host_symb <- c(host_symb_sets[[1]], host_symb_sets2[[2]])
multi_host_symb_alt <- c(host_symb_sets, host_symb_sets2)
}
\seealso{
`c` generic function
}
\author{
Wade Dismukes and Emmanuel Paradis
}
