% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval_tree.R
\name{eval_tree}
\alias{eval_tree}
\title{Print decision tree performance according to different metrics.}
\usage{
eval_tree(dat, task = c("classification", "regression"), metrics = NULL)
}
\arguments{
\item{dat}{Dataframe with truths (column `my_target`) and estimates (column `y_hat`)
of samples from original dataset.}

\item{task}{Character string indicating the type of problem,
either 'classification' (categorical outcome) or 'regression' (continuous outcome).}

\item{metrics}{A set of metric functions to evaluate decision tree,
defaults to common metrics for classification/regression problems.
Can be defined with `yardstick::metric_set`.}
}
\value{
Character string of the decision tree evaluation.
}
\description{
Print decision tree performance according to different metrics.
}
\examples{
eval_tree(compute_tree(penguins, target_lab = 'species')$dat)

}
