% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-write-methods.R
\name{readTree}
\alias{readTree}
\title{Read a Newick tree}
\usage{
readTree(file = NULL, text = NULL, ...)
}
\arguments{
\item{file}{file path}

\item{text}{Newick character string}

\item{...}{\code{plyr} arguments}
}
\description{
Return a \code{TreeMan} or \code{TreeMen} object from a Newick treefile
}
\details{
Read a single or multiple trees from a file, or a text string. Parallelizable.
}
\examples{
library(treeman)
tree <- readTree(text="((A:1.0,B:1.0):1.0,(C:1.0,D:1.0):1.0);")
}
\seealso{
\code{\link{writeTree}}, \code{\link{randTree}}, \url{https://en.wikipedia.org/wiki/Newick_format}
}

