% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbm_2way.R
\name{gbm_2way}
\alias{gbm_2way}
\title{Two-way interactions}
\usage{
gbm_2way(object, data, var.names = object$var.names, n.trees = object$n.trees)
}
\arguments{
\item{object}{A \code{\link[gbm]{gbm}} object.}

\item{data}{Data frame containing the original training data (or 
representative sample thereof).}

\item{var.names}{Character string specifying the predictor names to consider.}

\item{n.trees}{Integer specifying the number of trees to use.}
}
\value{
A data frame with the following three columns:
\describe{ 
  \item{var1}{The name of the first feature.} 
  \item{var2}{The name of the second feature.} 
  \item{h}{The corresponding H-statistic.} 
}
The resulting rows are sorted in descending order of \code{h}.
}
\description{
Computes Friedman's H-statistic (Friedman & Popescu, 2008) for all pairwise 
interaction effects in a \code{\link[gbm]{gbm}} model.
}
\references{
Friedman, J. H., & Popescu, B. E. (2008). Predictive Learning via Rule 
Ensembles. The Annals of Applied Statistics, 2(3), 916–954. 
http://www.jstor.org/stable/30245114
}
