% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.R
\name{node_raw_s_expression}
\alias{node_raw_s_expression}
\title{"Raw" S-expression}
\usage{
node_raw_s_expression(x)
}
\arguments{
\item{x}{\verb{[tree_sitter_node]}

A node.}
}
\value{
A single string containing the raw s-expression.
}
\description{
\code{node_raw_s_expression()} returns the "raw" s-expression as seen by
tree-sitter. Most of the time, \code{\link[=node_show_s_expression]{node_show_s_expression()}} provides a better
view of the tree, but occasionally it can be useful to see exactly what the
underlying C library is using.
}
\examples{
\dontshow{if (rlang::is_installed("treesitter.r")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
language <- treesitter.r::language()
parser <- parser(language)

text <- "1 + foo"
tree <- parser_parse(parser, text)
node <- tree_root_node(tree)

node_raw_s_expression(node)
\dontshow{\}) # examplesIf}
}
