% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_bal_unbal_tree.R
\name{create_fully_balanced_tree}
\alias{create_fully_balanced_tree}
\title{Create a fully balanced tree}
\usage{
create_fully_balanced_tree(phy)
}
\arguments{
\item{phy}{phylo object}
}
\value{
phylo phylo object
}
\description{
This function takes an input phylogeny, and returns a phylogeny
that is most ideally balanced tree, whilst having the same branching times as
the original input tree. Please note that if the number of tips is not even
or not a power of two, the tree may not have perfect balance, but the most
ideal balance possible.
}
\examples{
phy <- ape::rphylo(n = 16, birth = 1, death = 0)
bal_tree <- treestats::create_fully_balanced_tree(phy)
treestats::colless(phy)
treestats::colless(bal_tree) # much lower
}
