% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efftox.R
\name{efftox_parse_outcomes}
\alias{efftox_parse_outcomes}
\title{Parse a string of EffTox outcomes to binary vector notation.}
\usage{
efftox_parse_outcomes(outcome_string)
}
\arguments{
\item{outcome_string}{character string, conveying doses given and outcomes
observed.}
}
\value{
a list with elements \code{eff}, \code{tox}, \code{doses} and
\code{num_patients}. These elements are congruent with the same in
\code{efftox_params}.
}
\description{
Parse a string of EffTox outcomes to the binary vector notation
required by Stan for model invocation. The outcome string describes the doses
given and outcomes observed. The format of the string is described in Brock
et al. (2017). The letters E, T, N and B are used to represents patients that
experienced (E)fficacy only, (T)oxicity only, (B)oth efficacy and toxicity,
and (B)oth. These letters are concatenated after numerical dose-levels to
convey the outcomes of cohorts of patients. For instance, \code{2ETB}
represents a cohort of three patients that were treated at dose-level 2, and
experienced efficacy, toxicity and both events, respectively. The results of
cohorts are separated by spaces. Thus, \code{2ETB 1NN} extends our previous
example, where the next cohort of two were treated at dose-level 1 and both
patients experienced neither efficacy nor toxicity. See examples.

We present the notation in the EffTox setting but it is applicable in
general seamless phase I/II dose-finding scenarios.
}
\examples{
x = efftox_parse_outcomes('1NNE 2EEN 3TBB')
x$num_patients == 9
x$eff == c(0, 0, 1, 1, 1, 0, 0, 1, 1)
sum(x$tox) == 3

}
\references{
Brock et al. (submitted 2017), Implementing the EffTox
Dose-Finding Design in the Matchpoint Trial.
}
