% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.trip.R
\docType{methods}
\name{as.trip}
\alias{as.trip}
\alias{as.trip-methods}
\alias{as.trip,ltraj-method}
\alias{ltraj2trip}
\alias{coerce,trip,ltraj-method}
\alias{as.trip,track_xyt-method}
\title{Coercion from other classes to \code{trip} objects}
\usage{
as.trip(x, ...)
}
\arguments{
\item{x, }{ltr ltraj object}

\item{\dots}{Arguments passed to other methods. Ignored for \code{ltraj}
method.}
}
\value{
S4 trip object
}
\description{
Coercing objects to \code{trip} class
}
\section{Methods}{


\describe{

\item{coerce}{\code{signature(from="ltraj", to="trip")}}

\item{as.trip}{\code{signature(x="ltraj")}}

}
}

\examples{
 d <- data.frame(x=1:10, y=rnorm(10), tms=Sys.time() + 1:10, id=gl(2, 5))
tr <- trip(d)
if (require(adehabitatLT)) {
    l <- as(tr, "ltraj")
    ltraj2trip(l)
    as.trip(l)
}
}
