% Generated by roxygen2 (4.0.2): do not edit by hand
\name{ppv}
\alias{permutation}
\alias{permutations}
\alias{ppv}
\title{Permutations Pseudo-Vector}
\usage{
ppv(k, items)
}
\arguments{
\item{k}{the number of objects taken at a time.}

\item{items}{a vector of objects to be permuted.}
}
\value{
an instance of \code{PPV}.
}
\description{
The \code{PPV} class defines a pseudo-vector containing all
the \code{k}-permutations of the objects stored
in \code{items}. The function \code{ppv} is a constructor for this class.
}
\details{
The arrangement of permutations is similar, but in many cases not identical,
to that obtained from the
Steinhaus-Johnson-Trotter algorithm (see references).
}
\examples{
# create a pseudo-vector of 5-permutations from the first 10 letters
p <- ppv(5, letters[1:10])
# generate a description
print(p)
# compatable with length
length(p)
# inspect a few of the permutations "stored" in p
p[1]
p[1000]
p[length(p)]
}
\author{
Richard Ambler
}
\references{
Steinhaus-Johnson-Trotter algorithm. (2014, April 29).
In \emph{Wikipedia, The Free Encyclopedia}.
Retrieved 13:24, September 5, 2014
}
\seealso{
Combinations Pseudo-Vector \code{\link{cpv}}
}

