% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{NE_exp1}
\alias{NE_exp1}
\title{Data from Experiment 1 of Nadarevic and Erdfelder}
\format{
A data frame with 14,950 observations on 7 variables:
\describe{
  \item{\code{subj_id}}{Unique subject identifier.}

  \item{\code{item_id}}{Unique stimulus (statement) identifier.}

  \item{\code{repetition}}{Whether the statement was repeated (\code{old})
  or not (\code{new}).}

  \item{\code{delay}}{Testing interval, ten minutes (\code{10m}) or one
  week (\code{1w}) after initial exposure.}

  \item{\code{trating}}{Truth rating on a six-point scale, with higher
  values corresponding to greater perceived truth.}

  \item{\code{R}}{Deviation-coded numerical predictor for
  \code{repetition}, with \code{old} = .5 and \code{new} = -.5.}

  \item{\code{D}}{Deviation-coded numerical predictor for \code{delay},
  with \code{10m} = .5 and \code{1w} = -.5.}

}
}
\source{
The source data is from
  \insertCite{Nadarevic2014;textual}{truthiness}, which is freely
  available for download from \url{https://osf.io/eut35/}. The data
  included here has been reorganized for statistical modeling.
}
\usage{
NE_exp1
}
\description{
A dataset containing truth ratings from Experiment 1 of
\insertCite{Nadarevic2014;textual}{truthiness}.
}
\references{
\insertAllCited{}
}
\seealso{
\code{link{NE_items}}
}
\keyword{datasets}
