#' truthiness: Longitudinal Study of the Illusory Truth effect
#'
#' The truthiness package provides functions and data associated with
#' a longitudinal study of the Illusory Truth effect conducted by
#' \insertCite{Henderson_Simons_Barr_2021;textual}{truthiness}. The
#' illusory truth effect is the observation that people rate repeated
#' statements as more likely to be true. We tested the trajectory of
#' the illusory truth effect by collecting truth ratings for
#' statements repeated across four time intervals: immediately, one
#' day, one week, and one month following initial presentation. The
#' package contains the anonymized data for the study as well as
#' functions for analyzing the data, running simulations, and
#' calculating power. Further details about the project are available
#' at https://osf.io/nvugt/ including Stage 1 of the Registered
#' Report at the Journal of Cognition (https://osf.io/vqnx2/).
#'
#' @references
#'   \insertAllCited{}
#' @importFrom Rdpack reprompt
#' @docType package
#' @name truthiness
NULL
#> NULL
