% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reproduce.R
\name{reproduce_analysis}
\alias{reproduce_analysis}
\title{Reproduce the Analysis for Longitudinal Illusory Truth Study}
\usage{
reproduce_analysis(
  outfile = "analysis.html",
  refit = FALSE,
  savefig = FALSE,
  recipe = FALSE,
  parallel = TRUE,
  infile = NULL
)
}
\arguments{
\item{outfile}{Path to the HTML output file.}

\item{refit}{Whether to re-fit the cumulative link mixed model
\code{TRUE} or to use the built-in model fits (\code{FALSE}). Due
to the extremely time-consuming nature of model estimation, the
default is set to \code{FALSE}.}

\item{savefig}{Whether to save the two plots as separate PNG files
(\code{means_plot.png} and \code{validation_plot.png}).}

\item{recipe}{Include instructions on how to reproduce the analysis.}

\item{parallel}{Whether to fit models using a single CPU processing
core (\code{FALSE}) or multiple cores (\code{TRUE}, the
default). If \code{refit} is \code{FALSE}, this parameter is
ignored.}

\item{infile}{Path to the R Markdown script; \code{NULL} to use the
built-in script.}
}
\value{
A string with the path to the generated HTML report.

Path to the rendered HTML report.
}
\description{
Re-run the analysis for the
\insertCite{Henderson_Simons_Barr_2021;textual}{truthiness}
longitudinal truth study.
}
\details{
Runs R Markdown script containing the analysis code. The
  analysis is performed on the built-in preprocessed anonymized
  data (documented in \code{\link{truth_trajectory_data}}). The
  script output is rendered as an HTML report, specified by
  \code{outfile}. Although it is not necessary to do so, the master
  R Markdown script for processing real data can be accessed using

\code{rmarkdown::draft("analysis.Rmd",
                       "illusory-truth-analysis", "truthiness")}
}
\examples{
\donttest{
tf <- tempfile(fileext = ".html")

## Run the built-in R Markdown script without refitting models.
## To re-fit the models, set refit = TRUE
## (NB: refitting can take ~ 24 hours)
reproduce_analysis(tf)

browseURL(tf)

## clean up
if (file.exists(tf)) file.remove(tf)
}


}
\seealso{
\code{\link{reproduce_analysis_sim}}
}
