% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reproduce.R
\name{reproduce_analysis_sim}
\alias{reproduce_analysis_sim}
\title{Simulate the Analysis for Longitudinal Illusory Truth Study}
\usage{
reproduce_analysis_sim(
  path,
  outfile = "analysis.html",
  recipe = FALSE,
  parallel = TRUE,
  infile = NULL
)
}
\arguments{
\item{path}{Path to a subdirectory containing the preprocessed
anonymized (simulated) data files (see
\code{\link{simulate_resp_files}}).}

\item{outfile}{Path to the HTML output file.}

\item{recipe}{Include instructions on how to reproduce the analysis.}

\item{parallel}{Whether to fit models using a single CPU processing
core (\code{FALSE}) or multiple cores (\code{TRUE}, the
default).}

\item{infile}{Path to the R Markdown script; \code{NULL} to use the
built-in script.}
}
\description{
Runs the main analysis for
\insertCite{Henderson_Simons_Barr_2021;textual}{truthiness} on
simulated data.
}
\details{
Runs R Markdown script on the data in the provided
  subdirectory and renders the HTML report to \code{outfile}. The
  master R Markdown script can be accessed using:

\code{rmarkdown::draft("analysis.Rmd",
                       "illusory-truth-analysis-sim", "truthiness")}

Note that this script can take *very* long to run, depending on the
size of the simulated dataset, the number of processing cores, and
the computational power of the hardware.
}
\examples{
td_raw <- tempfile()  # temp dir for raw data
td_anon <- tempfile() # temp dir for preprocessed data

## simulate data and preprocess it

set.seed(62)
simulate_resp_files(32, path = td_raw, overwrite = TRUE)

\donttest{
## temporary files 
tf1 <- tempfile(fileext = ".html")
tf2 <- tempfile(fileext = ".html")

## run the built-in R Markdown preprocessing script
pp_report <- preprocess_simulated(path = td_raw, outpath = td_anon,
                                  report = tf1)

## run the built-in R Markdown analysis script
## this can take very long due to the CLMM fits
a_report <- reproduce_analysis_sim(path = td_anon,
                                   outfile = tf2,
                                   parallel = FALSE)

browseURL(a_report)

## clean up
file.remove(pp_report)
file.remove(a_report)
}

## clean up
unlink(td_raw, TRUE, TRUE)
unlink(td_anon, TRUE, TRUE)

}
