% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ar_mean.R
\name{ar_mean}
\alias{ar_mean}
\alias{ar_mean.linear}
\alias{ar_mean.setar}
\alias{ar_mean.lstar}
\title{Long-term mean of an AR(p) process}
\usage{
ar_mean(object, ...)

\method{ar_mean}{linear}(object, ...)

\method{ar_mean}{setar}(object, ...)

\method{ar_mean}{lstar}(object, ...)
}
\arguments{
\item{object}{an object of class \code{\link{linear}}, \code{\link{setar}} or \code{\link{lstar}}}

\item{\ldots}{unused argument}
}
\description{
Computes the long term mean of an AR process
}
\details{
The function computes the long-term mean of an AR(p) process, or of the corresponding sub-regimes in 
SETAR or LSTAR model. 
There are three possible cases:
\describe{
  \item{No constant nor trend}{The LT mean is 0}
  \item{constant}{The LT mean is given by const/(1-sum(AR coefs))}
  \item{Trend}{The LT mean is not defined}
}
}
\examples{
## estimate a (linear) AR, a SETAR and a LSTAR
lin_cst_l1 <-  linear(lh, m = 1, include = "const")
set_cst_l1 <-  setar(lh, m = 1, include = "const") 
lst_cst_l1 <-  lstar(lh, m = 1, include = "const", trace = FALSE)

ar_mean(lin_cst_l1)
ar_mean(set_cst_l1)
ar_mean(lst_cst_l1)
}
