% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/full_models.R
\docType{class}
\name{tscm-class}
\alias{tscm-class}
\alias{show,tscm-method}
\alias{coef,tscm-method}
\alias{sim,tscm-method}
\alias{predict,tscm-method}
\alias{kendall,tscm-method}
\title{Full models}
\usage{
\S4method{show}{tscm}(object)

\S4method{coef}{tscm}(object)

\S4method{sim}{tscm}(object, n = 1000)

\S4method{predict}{tscm}(object, data, x, type = "df", qtype = 7, proper = FALSE)

\S4method{kendall}{tscm}(object, lagmax = 20)
}
\arguments{
\item{object}{an object of the class.}

\item{n}{length of realization.}

\item{data}{vector of past data values.}

\item{x}{vector of arguments of prediction function.}

\item{type}{type of prediction function ("df" for density, "qf" for quantile function
or "dens" for density).}

\item{qtype}{type of empirical quantile estimate.}

\item{proper}{logical variable stating whether the standard empirical distribution function should
be used when the margin is empirical; otherwise an improper distribution that is bounded away from 0
and 1 is used.}

\item{lagmax}{maximum value of lag.}
}
\description{
Class of objects for composite time series models consisting
of stationary copula processes and marginal distributions.
}
\section{Methods (by generic)}{
\itemize{
\item \code{show}: Show method for tscm class

\item \code{coef}: Coefficient method for tscm class

\item \code{sim}: Simulation method for tscm class

\item \code{predict}: Prediction method for tscm class

\item \code{kendall}: Calculate Kendall's tau values for pair copulas for tscm class
}}

\section{Slots}{

\describe{
\item{\code{tscopula}}{an object of class \linkS4class{tscopula}.}

\item{\code{margin}}{an object of class \linkS4class{margin}.}
}}

\examples{
mod <- tscm(dvinecopula(family = "gauss", pars = 0.5), margin("doubleweibull"))
sim(mod)
}
