% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_fil_ema.R
\name{ts_fil_ema}
\alias{ts_fil_ema}
\title{Time Series Exponential Moving Average}
\usage{
ts_fil_ema(ema = 3)
}
\arguments{
\item{ema}{exponential moving average size}
}
\value{
a \code{ts_fil_ema} object.
}
\description{
Used to smooth out fluctuations, while giving more weight to
recent observations. Particularly useful when the data has a trend or
seasonality component.
}
\examples{
# time series with noise
library(daltoolbox)
data(tsd)
tsd$y[9] <- 2*tsd$y[9]

# filter
filter <- ts_fil_ema(ema = 3)
filter <- fit(filter, tsd$y)
y <- transform(filter, tsd$y)

# plot
plot_ts_pred(y=tsd$y, yadj=y)
}
