% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitG.R
\name{fitG}
\alias{fitG}
\title{Fit g distribution}
\usage{
fitG(x, verbose = "v")
}
\arguments{
\item{x}{data as a \code{numeric}.}

\item{verbose}{function verbosity. Values \code{v}, \code{vv} and \code{vvv} are admitted,
whereas other values (such as \code{""} or \code{FALSE}) will make the function
silent.}
}
\value{
Object of class \code{fitGH}. Useful methods include:
\itemize{
\item \code{coef()} point estimates of parameters
\item \code{print()} short information about the object
\item \code{summary()} summary information about the estimation process
}
}
\description{
Fit the g distribution on a dataset through maximum likelihood
\insertCite{bee2019b}{tukeyGH}.
}
\examples{
data("EPWS2014")

# Fit to EPWS2014 data
modG <- fitG(EPWS2014)
summary(modG)

}
\references{
\insertAllCited{}
}
