% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{autoplot.tune_results}
\alias{autoplot.tune_results}
\title{Plot tuning search results}
\usage{
\method{autoplot}{tune_results}(
  object,
  type = c("marginals", "parameters", "performance"),
  metric = NULL,
  eval_time = NULL,
  width = NULL,
  call = rlang::current_env(),
  ...
)
}
\arguments{
\item{object}{A tibble of results from \code{\link[=tune_grid]{tune_grid()}} or \code{\link[=tune_bayes]{tune_bayes()}}.}

\item{type}{A single character value. Choices are \code{"marginals"} (for a plot
of each predictor versus performance; see Details below), \code{"parameters"}
(each parameter versus search iteration), or \code{"performance"} (performance
versus iteration). The latter two choices are only used for \code{\link[=tune_bayes]{tune_bayes()}}.}

\item{metric}{A character vector or \code{NULL} for which metric to plot. By
default, all metrics will be shown via facets. Possible options are
the entries in \code{.metric} column of \code{collect_metrics(object)}.}

\item{eval_time}{A numeric vector of time points where dynamic event time
metrics should be chosen (e.g. the time-dependent ROC curve, etc). The
values should be consistent with the values used to create \code{object}.}

\item{width}{A number for the width of the confidence interval bars when
\code{type = "performance"}. A value of zero prevents them from being shown.}

\item{call}{The call to be displayed in warnings or errors.}

\item{...}{For plots with a regular grid, this is passed to \code{format()} and is
applied to a parameter used to color points. Otherwise, it is not used.}
}
\value{
A \code{ggplot2} object.
}
\description{
Plot tuning search results
}
\details{
When the results of \code{tune_grid()} are used with \code{autoplot()}, it tries to
determine whether a \emph{regular grid} was used.
\subsection{Regular grids}{

For regular grids with one or more numeric tuning parameters, the parameter
with the most unique values is used on the x-axis. If there are categorical
parameters, the first is used to color the geometries. All other parameters
are used in column faceting.

The plot has the performance metric(s) on the y-axis. If there are multiple
metrics, these are row-faceted.

If there are more than five tuning parameters, the "marginal effects" plots
are used instead.
}

\subsection{Irregular grids}{

For space-filling or random grids, a \emph{marginal} effect plot is created. A
panel is made for each numeric parameter so that each parameter is on the
x-axis and performance is on the y-xis. If there are multiple metrics, these
are row-faceted.

A single categorical parameter is shown as colors. If there are two or more
non-numeric parameters, an error is given. A similar result occurs is only
non-numeric parameters are in the grid. In these cases, we suggest using
\code{collect_metrics()} and \code{ggplot()} to create a plot that is appropriate for
the data.

If a parameter has an associated transformation associated with it (as
determined by the parameter object used to create it), the plot shows the
values in the transformed units (and is labeled with the transformation type).

Parameters are labeled using the labels found in the parameter object
\emph{except} when an identifier was used (e.g. \code{neighbors = tune("K")}).
}
}
\examples{
\dontshow{if (tune:::should_run_examples()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# For grid search:
data("example_ames_knn")

# Plot the tuning parameter values versus performance
autoplot(ames_grid_search, metric = "rmse")


# For iterative search:
# Plot the tuning parameter values versus performance
autoplot(ames_iter_search, metric = "rmse", type = "marginals")

# Plot tuning parameters versus iterations
autoplot(ames_iter_search, metric = "rmse", type = "parameters")

# Plot performance over iterations
autoplot(ames_iter_search, metric = "rmse", type = "performance")
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=tune_grid]{tune_grid()}}, \code{\link[=tune_bayes]{tune_bayes()}}
}
