% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a_tuar1.R
\name{tuar1}
\alias{tuar1}
\title{Time-uncertain AR(1) model}
\usage{
tuar1(y, ti.mu, ti.sd, n.sim, CV = FALSE, ...)
}
\arguments{
\item{y}{A vector of observations.}

\item{ti.mu}{A vector of estimates of timing of observations.}

\item{ti.sd}{A vector of standard deviations of timing.}

\item{n.sim}{A number of simulations.}

\item{CV}{TRUE/FALSE cross-validation indicator.}

\item{...}{list of optional parameters:\cr
- n.chains: number of MCMC chains, the default number of chains is set to 2.\cr
- n.cores: number of cores used in cross-validation. No value or 'MAX' applies all the available cores in computation.\cr
- Thin: thinning factor, the default values is set to 4.\cr}
}
\description{
\code{tuar1} estimates unbiased parameters of time-uncertain AR(1) model.
}
\examples{
# Note: Most of models included in tuts package are computationally intensive. In the example
# below I set parameters to meet CRAN's testing requirement of maximum 5 sec per example.
# A more practical example would contain N=50 in the first line of the code and n.sim=10000.

#1. Import or simulate the data (a simulation is chosen for illustrative purposes):
DATA=simtuts(N=10,Harmonics=c(4,0,0), sin.ampl=c(10,0, 0), cos.ampl=c(0,0,0),
            trend=0,y.sd=2, ti.sd=0.2)
y=DATA$observed$y.obs
ti.mu=DATA$observed$ti.obs.tnorm
ti.sd= rep(0.2, length(ti.mu))

#2. Fit the model:
n.sim=1000
TUAR1=tuar1(y=y,ti.mu=ti.mu,ti.sd=ti.sd,n.sim=n.sim,CV=TRUE,n.cores=2)

#3. Generate summary results (optional parameters are listed in brackets):
summary(TUAR1)                            # Summary results (CI, burn).

#4. Generate plots and diagnostics of the model (optional parameters are listed in brackets):
plot(TUAR1,type='predTUTS')               # One step out of salmple predictions (CI, burn).
plot(TUAR1,type='par', burn=0.4)          # Distributions of parameters (burn).
plot(TUAR1,type='mcmc')                   # MCMC diagnostics.
plot(TUAR1,type='cv', burn=0.4, CI=0.9)   # 5 fold cross validation (CI, burn).
plot(TUAR1,type='GR')                     # Gelman-Rubin diagnostic (CI, burn).
plot(TUAR1,type='volatility')             # Volatility realizaitons.
}
