% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bw.R
\name{bwCov}
\alias{bwCov}
\title{Covariance Bandwidth Calculation by Cross-Validation
\emph{bwCov} calculates a single bandwidth to estimate the time-varying variance-
covariance matrix.}
\usage{
bwCov(x, cv.block = 0, est = c("lc", "ll"), tkernel = c("Epa",
  "Gaussian"))
}
\arguments{
\item{x}{A matrix or a data frame.}

\item{cv.block}{A positive scalar with the size of the block in leave-one block-out cross-validation.
By default 'cv.block=0' meaning leave-one-out cross-validation.}

\item{est}{The nonparametric estimation method, one of "lc" (default) for linear constant
or "ll" for local linear.}

\item{tkernel}{The type of kernel used in the coefficients estimation method,
one of Epanesnikov ("Epa") or "Gaussian".}
}
\value{
A scalar.
}
\description{
Covariance Bandwidth Calculation by Cross-Validation
\emph{bwCov} calculates a single bandwidth to estimate the time-varying variance-
covariance matrix.
}
\examples{

data(CEES)
## Using a shorter set for a quick example
mydata <- tail (CEES, 50)
bw.cov <- bwCov(mydata)
Sigma.hat <- tvCov(mydata, bw = bw.cov)

}
