% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bal.table.mediation.R
\name{bal.table.mediation}
\alias{bal.table.mediation}
\title{Compute the balance table for mediation object.}
\usage{
bal.table.mediation(x, digits = 3, ...)
}
\arguments{
\item{x}{A \code{mediation} object}

\item{digits}{Number of digits to round to. Dafault: 3}

\item{...}{Additional arguments.}
}
\value{
\item{res}{tables detailing covariate balance across
exposure groups both before and after weighting}
}
\description{
Compute the balance table for mediation object.
}
\examples{
data("tMdat")

## tMdat is small simulated data set included in twangMediation for 
## demonstrating the functions. See ?tMdat for details

fit.es.max <- wgtmed(M ~ w1 + w2 + w3,
                      data = tMdat,
                      a_treatment = "A",
                      y_outcome = "Y",
                      total_effect_wts = tMdat$te.wgt,
                      method = "logistic"
                      )

bal.table.mediation(fit.es.max)
}
\seealso{
\code{\link{print.bal.table.mediation}}, \code{\link{wgtmed}}
}
