% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.mediation.R
\name{plot.mediation}
\alias{plot.mediation}
\title{Plot the \code{mediation} object.}
\usage{
\method{plot}{mediation}(x, subset = NULL, color = TRUE, ...)
}
\arguments{
\item{x}{weighted_mediation object}

\item{subset}{Used to restrict which of the \code{stop.method}s will be used
in the figure. For example \code{subset = c(1,3)} would indicate that the
first and third \code{stop.method}s (in alphabetical order of those specified
in the original call to the mediation function) should be included in the
figure. If x$method = \code{logistic} or \code{crossval}, there is no need to subset
as there is only one method used.}

\item{color}{If \code{color = FALSE}, figures will be gray scale. Default: \code{TRUE}.}

\item{...}{Additional arguments.}
}
\value{
Distribution plots of NIE1 (distribution of mediator for treatment
sample weighted to match distribution of mediator under control for the population)
and NIE0 (distribution of mediator for control sample weighted to match
distribution of mediator under treatment for the population) for each mediator.
For continuous mediators, distributions are plotted with density curves and
for categorical (factor) mediators, distributions are plotted with barplots. .
}
\description{
Plot the \code{mediation} object.
}
\examples{
data("tMdat")

## tMdat is small simulated data set included in twangMediation for 
## demonstrating the functions. See ?tMdat for details

fit.es.max <- wgtmed(M ~ w1 + w2 + w3,
                      data = tMdat,
                      a_treatment = "A",
                      y_outcome = "Y",
                      total_effect_wts = tMdat$te.wgt,
                      method = "ps",
                      ps_n.trees=1500,
                      ps_shrinkage=0.01,
                      ps_stop.method=c("es.max")
                      )

plot(fit.es.max)
}
\seealso{
\code{\link{wgtmed}} for function input
}
