% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remap.R
\name{remap}
\alias{remap}
\alias{remap,Raster-method}
\alias{remap,data.table-method}
\alias{remap,character-method}
\title{Spatial aggregation}
\usage{
remap(x, y)

\S4method{remap}{Raster}(x, y)

\S4method{remap}{data.table}(x, y)

\S4method{remap}{character}(x, y)
}
\arguments{
\item{x}{Raster* object; data.table (see details); filename (character, see details)}

\item{y}{numeric}
}
\value{
Raster* object; data.table
}
\description{
The function \code{remap} aggregates data into a new grid resolution.
}
\details{
If `x` is a data.table, its columns should be named: "lon", "lat", "date", and "value"

If `x` is a filename, it should point to a *.nc file.
}
\examples{
\dontrun{
download_data("gldas-vic", tempdir(), timestep = "yearly")
r <- raster::brick(paste0(tempdir(),
"/gldas-vic_tp_mm_land_194801_201412_025_yearly.nc"))
s <- remap(r, 1)
}
}
