% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tweedie_integrand.R
\name{tweedie_integrand}
\alias{tweedie_integrand}
\title{Display Integrand Information for Tweedie Fourier inversion}
\usage{
tweedie_integrand(y, power, mu, phi, t = seq(0, 5, length = 200), 
                  type = "PDF", whichPlots = 1:4, yLimits = NULL)
}
\arguments{
\item{y}{vector of quantiles.}

\item{power}{a synonym for \eqn{\xi}{xi}; the Tweedie power-index on the variance.}

\item{mu}{the mean parameter \eqn{\mu}{mu}.}

\item{phi}{the dispersion parameter \eqn{\phi}{phi}.}

\item{t}{the values of the variable over which to integrate; the default is \code{t = seq(0, 5, length = 200)}.}

\item{type}{either \code{"PDF"} (the default) for the (probability) density function, or \code{"CDF"} for the (cumulative) distribution function.}

\item{whichPlots}{which combination of the four plots (described below) are produced; by default, all four are produced (i.e., \code{whichPlots = 1:4}).}

\item{yLimits}{the \eqn{y}{y}-limits to use when plotting the integrand; the default is \code{NULL} which uses R defaults.}
}
\value{
A list containing the real and imaginary parts of \eqn{k(t)}{k(t)}, \code{Real} and \code{Imag} respectively, plus the values of the integrand as \code{IG}.
The main purpose of the function is the side-effect of producing a \eqn{2\times2}{2x2} grid of plots.
The first is the imaginary parts of \eqn{k(t)}{k(t)}.
The second is \eqn{\sin\Im k(t)}{sinIm[k(t)]}.
The third is the real part of \eqn{\Re k(t)}{Re[k(t)]}
The fourth is the integrand, with the envelope shown as a dashed line.
}
\description{
Plots the integrand for Fourier inversion and the real and imaginary parts separately.
}
\details{
The Tweedie family of distributions belong to the class of exponential dispersion models (\acronym{edm}s), famous for their role in generalized linear models. 
The Tweedie distributions are the \acronym{edm}s with a variance of the form \eqn{\mbox{var}[Y] = \phi\mu^p}{var(Y) = phi * mu^power} where \eqn{p}{power} is greater than or equal to one, or less than or equal to zero.

\emph{This function only evaluates for \eqn{p}{power} greater than or equal to one.}

Special cases include the normal (\eqn{p = 0}{power = 0}), Poisson (\eqn{p = 1}{power = 1} with \eqn{\phi = 1}{phi = 1}), gamma (\eqn{p = 2}{power = 2}) and inverse Gaussian (\eqn{p = 3}{power = 3}) distributions. For other values of \code{power}, the distributions are still defined but cannot be written in closed form, and hence evaluation is very difficult.

When \eqn{1 < p < 2}{1 < power < 2}, the distribution are continuous for \eqn{Y}{Y} greater than zero, with a positive mass at \eqn{Y = 0}{Y = 0}. For \eqn{p > 2}{power > 2}, the distributions are continuous for \eqn{Y}{Y} greater than zero.

This function displays the integrand that is evaluated for computing the Fourier inversion, for the PDF or CDF.
}
\examples{
tweedie_integrand(2, power = 3, mu = 1, phi = 1)

}
\references{
Dunn, P. K. and Smyth, G. K. (2008). Evaluation of Tweedie exponential dispersion model densities by Fourier inversion. \emph{Statistics and Computing}, \bold{18}, 73--86. \doi{10.1007/s11222-007-9039-6}

Dunn, Peter K and Smyth, Gordon K (2005). Series evaluation of Tweedie exponential dispersion model densities \emph{Statistics and Computing}, \bold{15}(4). 267--280. \doi{10.1007/s11222-005-4070-y}

Dunn, Peter K and Smyth, Gordon K (2001). Tweedie family densities: methods of evaluation. \emph{Proceedings of the 16th International Workshop on Statistical Modelling}, Odense, Denmark, 2--6 July

Jorgensen, B. (1987). Exponential dispersion models. \emph{Journal of the Royal Statistical Society}, B, \bold{49}, 127--162.

Jorgensen, B. (1997). \emph{Theory of Dispersion Models}. Chapman and Hall, London.

Tweedie, M. C. K. (1984). An index which distinguishes between some important exponential families. \emph{Statistics: Applications and New Directions. Proceedings of the Indian Statistical Institute Golden Jubilee International Conference} (Eds. J. K. Ghosh and J. Roy), pp. 579-604. Calcutta: Indian Statistical Institute.
}
\seealso{
\code{\link{dtweedie}}
}
\author{
Peter Dunn (\email{pdunn2@usc.edu.au})
}
\keyword{models}
