% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tile_read.R
\name{tile_read}
\alias{tile_read}
\title{Single tile read}
\usage{
tile_read(bspfile)
}
\arguments{
\item{bspfile}{path to the .bsp file.}
}
\value{
An S4 Object of class \code{\link[=Tile-class]{Tile}}.
}
\description{
The function loads a single tile to R as an object of class \code{\link[=Tile-class]{Tile}}.

The function is also capable to load the toy mosaic produced by the Agilent sofware. You can do so by passing as bspfile parameter the .bsp file comprised in a mosaic folder. However, beware! the toy mosaic IS NOT the complete mosaic, it is only a reduced version of it (i.e. you will lose resolution, and you will not longer know the pixel size). Use it with care.
}
\examples{
x <- tile_read(base::system.file("extdata/tile.bsp", package = "uFTIR"))
}
