% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rs_rinlidar.R
\name{r_in_lidar}
\alias{r_in_lidar}
\title{wraps the r.in.lidar tool}
\usage{
r_in_lidar(input = NULL, output = NULL, file = NULL, method = NULL,
  type = NULL, base_raster = NULL, zrange = NULL, zscale = NULL,
  intensity_range = NULL, intensity_scale = NULL, percent = NULL,
  pth = NULL, trim = NULL, resolution = NULL, return_filter = NULL,
  class_filter = NULL, flags = c("e", "n", "overwrite", "o"))
}
\arguments{
\item{input}{input}

\item{output}{output}

\item{file}{file}

\item{method}{method}

\item{type}{type}

\item{base_raster}{base_raster}

\item{zrange}{zrange}

\item{zscale}{zscale}

\item{intensity_range}{intensity_range}

\item{intensity_scale}{intensity_scale}

\item{percent}{percent}

\item{pth}{pth}

\item{trim}{trim}

\item{resolution}{resolution}

\item{return_filter}{return_filter}

\item{class_filter}{class filter}

\item{flags}{flags}

\item{r.in.lidar}{[-penosgijdv]}
}
\description{
simple wrapper for 'r.in.lidar' to calculate LiDAR derived raster grids. It creates a \code{raster*} object.
}
\examples{
\dontrun{
require(uavRst)
##- Straightforward example to generate a DTM 
    based on the class 2 minimum returns of a LiDAR file
    
##- set up environment
path<-tempdir()
setwd(path)

##- get a laz file from Mr. Isenburg
url="http://www.cs.unc.edu/~isenburg/lastools/download/test/s1885565.laz"
utils::download.file(url=url,
                     destfile="test.laz",  
                     quiet = TRUE, 
                     mode = "wb")
##- convert it from laz to las (obligatory format for using r.in.lidar)
lastool(tool="laz2las",paste0(path,"/test.laz"))

##- extract extent for setting up GRASS region
ext<-lastool(lasFile =  paste0(path,"/test.las"))

##- set up GRASS
proj4 = "+proj=utm +zone=32 +datum=WGS84 +units=m +no_defs"
result<-link2GI::linkGRASS7(spatial_params = c(ext[2],ext[1],ext[4],ext[3],proj4),
                             resolution = 0.5)
                             
##- use the r.in.lidar tool to generate a pseudo surface model
r_in_lidar(input = paste0(getwd(),"/test.las"),
           output = "dem",
           method = "min",
           resolution = 30,
           class_filter = 2)
           
##- visualize it
raster::plot(raster::raster(rgrass7::readRAST("dem")))
                            
}
}
\seealso{
\href{https://grass.osgeo.org/grass70/manuals/r.in.lidar.html}{r.in.lidar help}
}
\author{
Chris Reudenbach
}
