% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rs_textures.R
\name{morpho_dem}
\alias{morpho_dem}
\title{calculates most important DEM parameters}
\usage{
morpho_dem(dem, item = c("hillshade", "slope", "aspect", "TRI", "TPI",
  "Roughness", "SLOPE", "ASPECT", "C_GENE", "C_PROF", "C_PLAN", " C_TANG",
  " C_LONG", "C_CROS", "C_MINI", "C_MAXI", "C_TOTA", "C_ROTO", "MTPI"),
  verbose = FALSE, morphoMethod = 6, minScale = 1, maxScale = 8,
  numScale = 2, retRaster = TRUE, giLinks = NULL)
}
\arguments{
\item{dem}{character filname to GeoTiff containing one channel DEM}

\item{item}{character list containing the keywords of the DEM parameter to be calculated. Default parameter are c("hillshade", "slope", "aspect", "TRI", "TPI", "Roughness", "SLOPE", "ASPECT", "C_GENE", "C_PROF", "C_PLAN", " C_TANG"," C_LONG", "C_CROS", "C_MINI", "C_MAXI", "C_TOTA", "C_ROTO", "MTPI")}

\item{verbose}{logical. be quiet}

\item{morphoMethod}{numeric. saga morphometric method  see also: \href{http://www.saga-gis.org/saga_tool_doc/6.2.0/ta_morphometry_0.html}{SAGA GIS Help}. GDAL parameters see also: \href{https://www.gdal.org/gdaldem.html}{gdaldem}}

\item{minScale}{numeric. in scale for multi scale TPI see also: \href{http://www.saga-gis.org/saga_tool_doc/6.2.0/ta_morphometry_28.html}{SAGA GIS Help}}

\item{maxScale}{numeric. max scale for multi scale TPI see also: \href{http://www.saga-gis.org/saga_tool_doc/6.2.0/ta_morphometry_28.html}{SAGA GIS Help}}

\item{numScale}{numeric. number of scale for multi scale TPI see also: \href{http://www.saga-gis.org/saga_tool_doc/6.2.0/ta_morphometry_28.html}{SAGA GIS Help}}

\item{retRaster}{boolean if TRUE a raster stack is returned}

\item{giLinks}{list. of GI tools cli pathes}
}
\description{
calculates most important DEM parameters
}
\note{
please provide a GeoTiff file
}
\examples{
\dontrun{
##- required packages
require(uavRst)
require(link2GI)
setwd(tempdir())
giLinks<-list()
## check if OTB exists
giLinks$otb <- link2GI::linkOTB()
giLinks$saga <- link2GI::linkSAGA()
giLinks$grass <- link2GI::linkGRASS7(returnPaths = TRUE)
if (giLinks$otb$exist & giLinks$saga$exist & giLinks$grass$exist) {
data("mrbiko")
proj = "+proj=utm +zone=32 +datum=WGS84 +units=m +no_defs +ellps=WGS84 +towgs84=0,0,0"
mrbiko <- raster::projectRaster(mrbiko, crs = proj,method = "ngb",res = 20)
raster::writeRaster(mrbiko,"dem.tif",overwrite=TRUE)
r<-morpho_dem(dem="dem.tif",c("hillshade", "slope", "aspect", "TRI", "TPI",
                              "Roughness", "SLOPE", "ASPECT",  "C_GENE", "C_PROF",
                              "C_PLAN", " C_TANG"," C_LONG", "C_CROS"),
                              giLinks= giLinks)
r_st=raster::stack(r)
names(r_st)=names(r)
raster::plot(r_st)
}
}
}
