% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_preprocessing.R
\name{retrend_predictions}
\alias{retrend_predictions}
\title{Restors the trend in the prediction}
\usage{
retrend_predictions(dt_predictions, trend, log_transform = FALSE)
}
\arguments{
\item{dt_predictions}{Dataframe of predictions with columns \code{value},
\code{prediction}, \code{prediction_lower}, \code{prediction_upper}}

\item{trend}{lm object generated by \code{\link[=detrend]{detrend()}}}

\item{log_transform}{Returns values to solution space, if they have been
log transformed during detrending. Use only in combination with \code{log_transform}
parameter in detrend function.}
}
\value{
Retrended dataframe with same structure as \code{dt_predictions}
which is returned by any of the run_model() functions.
}
\description{
Takes a dataframe of predictions as returned by any of
the 'run_model' functions and restores a trend which was previously
removed via \code{\link[=detrend]{detrend()}}. This is necessary for the predictions
and the true values to have the same units. The function is basically
the inverse function to \code{\link[=detrend]{detrend()}} and should only be used in
combination with it.
}
\examples{
\donttest{
data(mock_env_data)
split_data <- list(
  train = mock_env_data[1:80, ],
  apply = mock_env_data[81:100, ]
)
params <- load_params()
detrended_list <- detrend(split_data,
  mode = "linear"
)
trend <- detrended_list$model
detrended_train <- detrended_list$train
detrended_apply <- detrended_list$apply
result <- run_lightgbm(
  train = detrended_train,
  test = detrended_apply,
  model_params = params$lightgbm,
  alpha = 0.9,
  calc_shaps = FALSE
)
retrended_predictions <- retrend_predictions(result$dt_predictions, trend)
}
}
