% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractor_functions.R
\name{extract_biomarkers}
\alias{extract_biomarkers}
\title{Extract NMR metabolomic biomarkers from a data.frame of UK Biobank fields}
\usage{
extract_biomarkers(x)
}
\arguments{
\item{x}{\code{data.frame} with column names "eid" followed by extracted
fields e.g. "p23474_i0", "p23474_i1", \dots, "p23467_i1".}
}
\value{
a \code{data.frame} or \code{data.table} with column names "eid",
        and "visit_index", followed by columns for each biomarker
       e.g. "bOHbutyrate", \dots, "Valine".
}
\description{
Given an input \code{data.frame} loaded from a dasaset of
\href{https://biobank.ndph.ox.ac.uk/showcase/label.cgi?id=220}{NMR metabolomics fields}
extracted by the Table Exporter tool on the
\href{https://ukbiobank.dnanexus.com/landing}{UK Biobank Research Analysis Platform},
this function extracts the NMR metabolomics biomarkers giving them short variable
names as listed in the \code{\link{nmr_info}} information data sheet
available in this package.
}
\details{
Data sets extracted on the \href{https://ukbiobank.dnanexus.com/landing}{UK Biobank Research Analysis Platform}
have one row per UK Biobank participant, whose project specific sample
identifier is given in the first column named "eid". Columns following this
follow a \href{https://dnanexus.gitbook.io/uk-biobank-rap/working-on-the-research-analysis-platform/accessing-data/accessing-phenotypic-data#database-columns}{naming scheme}
based on the unique identifier of each field, assessment visit, and (optionally if relevant)
repeated measurement of "p<field_id>_i<visit_index>_a<repeat_index>". For example,
the measurement of 3-Hydroxybutyrate at baseline assessment has the column name
"p23474_i0". For the UKB NMR data, measurements are available at baseline assessment
and the first repeat assessment (e.g. "p23474_i1"). For the UKB NMR data, the
<repeat_index> is reserved for cases where biomarker measurements have more than
one QC Flag (see \code{\link{extract_biomarker_qc_flags}()}).

The \code{data.frame} returned by this function gives each field a unique
recognizable name, with measurements from baseline and repeat assessment
given in separate rows. The "visit_index" column immediately after the "eid"
column indicates whether the biomarker measurement was quantified from the
blood samples taken at baseline assessment (visit_index == 0) or first repeat
assessment (visit_index == 1). Rows are uniquely identifiable
by the combination of entries in columns "eid" and "visit_index".

This function will also work with data predating the Research Analysis Platform,
including data sets extracted by the \href{https://biobank.ctsu.ox.ac.uk/crystal/exinfo.cgi?src=accessing_data_guide}{ukbconv}
tool and/or the \code{ukbtools} R package.

If your UK Biobank project only has access to a subset of biomarkers, then
this function will only return the subset of ratios that can be computed from
the biomarker data provided.

A \code{data.table} will be returned instead of a \code{data.frame} if the
the user has loaded the package into their R session.
}
\examples{
ukb_data <- ukbnmr::test_data # Toy example dataset for testing package
nmr <- extract_biomarkers(ukb_data)

}
